import numpy as np

time_table = {
    'hc-rnd': {'bamcts-sl': [(7, 35, 20), (13, 1, 22), (13, 4, 10)], 'bamcts': [(17, 38, 7), (13, 25, 44), (12, 45, 2)], 'bambrl': [(0, 37, 12), (1, 27, 11), (1, 30, 24)]},
    'hp-rnd': {'bamcts-sl': [(1, 21, 21, 31), (2, 2, 37, 44), (2, 2, 5, 50)], 'bamcts': [(2, 17, 4, 18), (2, 19, 36, 19), (2, 15, 0, 59)], 'bambrl': [(4, 28, 25), (5, 51, 57), (6, 25, 46)]},
    'wk-rnd': {'bamcts-sl': [(0, 22, 48, 48), (1, 2, 48, 57), (1, 3, 21, 41)], 'bamcts': [(1, 14, 38, 19), (1, 12, 32, 7), (1, 14, 58, 53)], 'bambrl': [(3, 37, 31), (5, 44, 55), (6, 12, 47)]},
    'hc-med': {'bamcts-sl': [(8, 19, 48), (14, 39, 0), (14, 42, 59)], 'bamcts': [(16, 23, 34), (13, 27, 31), (16, 2, 52)], 'bambrl': [(1, 36, 13), (2, 6, 2), (2, 3, 17)]},
    'hp-med': {'bamcts-sl': [(1, 1, 42, 11), (0, 15, 21, 16), (0, 15, 35, 18)], 'bamcts': [(2, 19, 13, 0), (2, 19, 37, 14), (2, 19, 42, 16)], 'bambrl': [(1, 31, 59), (1, 51, 46), (1, 55, 51)]},
    'wk-med': {'bamcts-sl': [(0, 21, 27, 48), (1, 0, 45, 8), (1, 1, 45, 42)], 'bamcts': [(1, 13, 25, 30), (1, 10, 43, 4), (1, 3, 49, 58)], 'bambrl': [(3, 16, 54), (5, 25, 40), (5, 32, 42)]},
    'hc-rep': {'bamcts-sl': [(0, 23, 41, 57), (1, 0, 32, 5), (1, 1, 51, 32)], 'bamcts': [(0, 21, 11, 22), (0, 22, 1, 51), (1, 0, 4, 19)], 'bambrl': [(1, 38, 34), (2, 6, 19), (2, 33, 47)]},
    'hp-rep': {'bamcts-sl': [(17, 51, 53), (17, 54, 7), (17, 51, 54)], 'bamcts': [(13, 22, 14), (11, 2, 1), (13, 39, 22)], 'bambrl': [(5, 27, 18), (5, 8, 3), (5, 29, 33)]},
    'wk-rep': {'bamcts-sl': [(1, 6, 9, 52), (1, 22, 21, 59), (1, 20, 19, 35)], 'bamcts': [(3, 8, 19, 28), (3, 2, 57, 11), (3, 3, 44, 18)], 'bambrl': [(8, 23, 29), (7, 54, 39), (7, 44, 13)]},
    'hc-exp': {'bamcts-sl': [(1, 8, 44, 46), (1, 8, 34, 3), (1, 8, 32, 54)], 'bamcts': [(11, 54, 1), (12, 15, 4), (13, 45, 46)], 'bambrl': [(3, 33, 50), (4, 21, 13), (6, 12, 27)]},
    'hp-exp': {'bamcts-sl': [(2, 19, 48, 32), (2, 11, 16, 6), (2, 9, 17, 33)], 'bamcts': [(3, 21, 17, 40), (2, 21, 30, 15), (2, 19, 50, 18)], 'bambrl': [(4, 40, 56), (5, 18, 28), (5, 48, 8)]},
    'wk-exp': {'bamcts-sl': [(1, 1, 58, 24), (1, 16, 37, 58), (1, 14, 26, 2)], 'bamcts': [(2, 9, 4, 24), (2, 9, 17, 54), (2, 5, 24, 7)], 'bambrl': [(1, 41, 8), (3, 24, 9), (3, 35, 36)]}
}

times = {}
for k, d in time_table.items():
    times[k] = {}
    for a, l in d.items():
        durations = []
        for t in l:
            if len(t) == 3:
                durations.append(t[0] + t[1] / 60.0 + t[2] / 3600.0)
            else:
                assert len(t) == 4
                durations.append(t[0] * 24.0 + t[1] + t[2] / 60.0 + t[3] / 3600.0)
        times[k][a] = [np.mean(durations), np.std(durations)]

for k in times:
    print(k)
    for a in times[k]:
        print(f"{a}: {times[k][a][0]:.1f} $\pm$ {times[k][a][1]:.1f}")